package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Obtention des informations sur le slot
 *
 */
public class InfoSlot{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(InfoSlot.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlot Identifiant du slot
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlot) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
		
				ResultatInfo resultat = new ResultatInfo("Obtenir des informations sur le slot ");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
					
					// Traitement  tester
					CK_SLOT_INFO info = librairie.C_GetSlotInfo(idSlot);
					
					if(info != null) {

						// Formatage du rsultat
						resultat.appendTraitement((new String(info.slotDescription)).trim()+" (C_GetSlotInfo)");
						infos.put("Description du slot",new String(info.slotDescription));
						infos.put("Identifiant du fabricant du slot",new String(info.manufacturerID));
						infos.put("La carte est-elle prsente?",(info.flags & PKCS11Constants.CKF_TOKEN_PRESENT)!=0?"Oui":"Non");
						infos.put("Le lecteur gre-t-il les supports amovibles?",(info.flags & PKCS11Constants.CKF_REMOVABLE_DEVICE)!=0?"Oui":"Non");
						infos.put("Le slot est-il un slot matriel?",(info.flags & PKCS11Constants.CKF_HW_SLOT)!=0?"Oui":"Non");
						infos.put("Version matrielle du slot",info.hardwareVersion.toString());
						infos.put("Version firmware du slot",info.firmwareVersion.toString());
					
					} else {
						
						resultat.appendTraitement("(C_GetSlotInfo)");
						
						// Si les informations sont nulles on lve l'exception
						log.error("L'operation a retourne des informations nulles");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_SLOT, "L'opration a retourn des informations nulles");
						
					}
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
				
				return resultat;
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_SLOT, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_SLOT, "Une erreur inattendue est survenue");
			
		}
	}

}
